<?php
require_once("../layouts/members/head.php");

/* =====================================
   NEW PAN TO MASK UID API
   ===================================== */
function pantomaskaadhar_run_new($request)
{
    $panNumber = strtoupper($request['panNumber']);
    $api_key   = "APIKEYPASTEE"; // 🔥 REPLACE WITH YOUR API KEY // Buy APi From This Website https://apizone.co.in ( Design & Development By APIZONE )
 
    $url = "https://kycapizone.in/api/v2/pan/pantomaskuid.php"
         . "?api_key={$api_key}&pan={$panNumber}";

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    $res = json_decode($response, true);

    // ✅ STATUS = 100 means success
    if (isset($res['status']) && (string)$res['status'] === '100') {
        return [
            'status'  => '100',
            'pan'     => $res['result']['pan'] ?? '',
            'aadhar'  => $res['result']['aadhaar_no'] ?? '',
            'maskpan' => $res['result']['mask_pan'] ?? '',
            'message' => $res['message'] ?? '',
            'link'    => $res['result']['link_status'] ?? '',
        ];
    } else {
        return [
            'status' => '101',
            'error'  => $res['message'] ?? 'API Error'
        ];
    }
}

/* =====================================
   MAIN PAGE
   ===================================== */

$response = [];

if ($user_data['pan_to_maskuid_service'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
<div class="col-md-4 mb-2">
<div class="card text-danger">
<div class="card-header bg-primary text-white py-2">
<div class="d-flex align-items-center">
<span class="mr-auto"><?= file_name() ?></span>
<button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
<i class="fas fa-arrow-left"></i> Back
</button>
</div>
</div>

<div class="p-3 text-dark">
<?php
if (isset($_POST['submit'])) {

    $panNumber = is_valid_pan($_POST['panNumber']);

    if (!empty($panNumber)) {

        $amount      = $user_data['pan_uid_status_fee'];
        $old_balance = $user_data['balance'];
        $new_balance = $old_balance - $amount;

        if ($old_balance >= $amount) {

            $order_id = order_txn_id();

            // 🔥 CALL NEW API
            $response = pantomaskaadhar_run_new([
                'panNumber' => $panNumber,
                'order_id'  => $order_id
            ]);

            if (isset($response['status']) && $response['status'] == '100') {

                // WALLET UPDATE
                db_update(
                    "members",
                    ["balance" => $new_balance],
                    " user_id='{$user_data['user_id']}' "
                );

                // REPORT ENTRY
                db_insert("reports", [
                    'site_id'        => $site_data['site_id'],
                    'user_id'        => $user_data['user_id'],
                    'username'       => $user_data['username'],
                    'name'           => $user_data['name'],
                    'operator'       => $user_data['usertype'],
                    'parent_id'      => $user_data['parent_id'],
                    'order_id'       => $order_id,
                    'service'        => "PAN TO MASK UID",
                    'type'           => "Debit",
                    'account_number' => $panNumber,
                    'app_type'       => "PAN TO MASK UID",
                    'amount'         => $amount,
                    'main_amount'    => $amount,
                    'old_balance'    => $old_balance,
                    'new_balance'    => $new_balance,
                    'txn_id'         => $order_id,
                    'ref_id'         => $response['aadhar'],
                    'description'    => "Rs.{$amount} Debited for PAN {$panNumber} Mask UID",
                    'date_time'      => current_timestamp(),
                    'status'         => "Success"
                ]);

                // SMS
                $whamessage = "Dear {$user_data['name']},\n"
                            . "PAN to Mask Aadhaar completed.\n\n"
                            . "PAN: {$response['maskpan']}\n"
                            . "Aadhaar: {$response['aadhar']}\n\n"
                            . "{$site_data['brand']}";

                send_sms($user_data['mobile'], $whamessage);

            } else {
                awal_alert_msg($response['error'], 'error');
            }

        } else {
            awal_alert_msg("Insufficient Wallet Balance!", 'error');
        }
    } else {
        awal_alert_msg("Invalid PAN Number!", 'error');
    }
}
?>

<form method="POST" class="row">
<div class="col-md-12 mb-3">
<label>PAN Number</label>
<input type="text" name="panNumber"
maxlength="10"
class="form-control"
placeholder="ABCDE1234F"
pattern="^[A-Z]{5}[0-9]{4}[A-Z]$"
oninput="this.value=this.value.toUpperCase()"
required>
</div>

<div class="col-md-12 mb-3 d-flex justify-content-between">
<button type="button" class="btn btn-secondary">
<i class="fas fa-inr"></i> <?= $user_data['pan_to_mask_uid_fee']; ?>
</button>

<button type="submit" name="submit"
class="btn btn-primary"
onclick="return confirm('Are you sure?');">
Submit
</button>

<button type="button" class="btn btn-warning"
data-toggle="modal" data-target="#showDetailsModal">
Show
</button>
</div>
</form>
</div>
</div>
</div>
</div>

<!-- ================= MODAL ================= -->
<div class="modal fade" id="showDetailsModal">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Fetched Details</h5>
<button class="close" data-dismiss="modal">&times;</button>
</div>

<div class="modal-body">
<?php if (!empty($response['aadhar'])) { ?>
<input class="form-control mb-2" value="<?= htmlspecialchars($panNumber) ?>" readonly>
<input class="form-control mb-2" value="<?= htmlspecialchars($response['aadhar']) ?>" readonly>
<input class="form-control mb-2" value="<?= htmlspecialchars($response['message']) ?>" readonly>
<?php } else { ?>
<p>No details fetched yet.</p>
<?php } ?>
</div>

<div class="modal-footer">
<button class="btn btn-danger" data-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>

<script>
<?php if (!empty($response['aadhar'])) { ?>
$(document).ready(function(){
    $('#showDetailsModal').modal('show');
});
<?php } ?>
</script>

<?php
} else {
require_once("404.php");
}
} else {
awal_alert_msg('You Do Not Have Any PAN Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>
